<?php
namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * VM\ApiBundle\Entity\UserCompanyRoleType
 *
 * @ORM\Table(name="user_company_role_types")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\UserCompanyRoleTypesRepository")
 *
 * @ExclusionPolicy("all")
 */
class UserCompanyRoleTypes
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $id;

    /**
     * @var string $symbol
     *
     * @ORM\Column(name="symbol", type="string", length=50)
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $symbol;

    /**
     * @var string $description
     *
     * @ORM\Column(name="description", type="string", length=255)
     *
     * @Expose
     * @AnnotationGroups({"details","companyDetails"})
     */
    private $description;

    /**
     * Inverse Side
     *
     * @ORM\ManyToMany(targetEntity="User", mappedBy="companyRoles")
     */
    private $users;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set symbol
     *
     * @param string $symbol
     * @return UserCompanyRoleTypes
     */
    public function setSymbol($symbol)
    {
        $this->symbol = $symbol;
    
        return $this;
    }

    /**
     * Get symbol
     *
     * @return string 
     */
    public function getSymbol()
    {
        return $this->symbol;
    }

    /**
     * Set description
     *
     * @param string $description
     * @return UserCompanyRoleTypes
     */
    public function setDescription($description)
    {
        $this->description = $description;
    
        return $this;
    }

    /**
     * Get description
     *
     * @return string 
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->users = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Add users
     *
     * @param \VM\ApiBundle\Entity\User $users
     * @return UserCompanyRoleTypes
     */
    public function addUser(\VM\ApiBundle\Entity\User $users)
    {
        $this->users[] = $users;
    
        return $this;
    }

    /**
     * Remove users
     *
     * @param \VM\ApiBundle\Entity\User $users
     */
    public function removeUser(\VM\ApiBundle\Entity\User $users)
    {
        $this->users->removeElement($users);
    }

    /**
     * Get users
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getUsers()
    {
        return $this->users;
    }
}